// Primary fire fish projectile
class Fishy expands StingerProjectile;

var texture FishSkins[6];

function PostBeginPlay()
{
	skin = FishSkins[Rand(6)]; // Randomize and add some color
}

auto state Flying
{
	simulated function ProcessTouch( Actor Other, Vector HitLocation )
	{
		local int hitdamage;
		local vector hitDir;
		local actor bld;
		
		if (Other != instigator && StingerProjectile(Other) == none)
		{
			if ( Role == ROLE_Authority )
			{
				hitDir = Normal(Velocity);
				if ( FRand() < 0.2 )
					hitDir *= 5;
	
				Other.TakeDamage(16, instigator, HitLocation, Normal(Velocity), 'Hacked');
				bld=Spawn(class'BloodBurst');
				bld.SetLocation(HitLocation);
				PlaySound(ImpactSound, SLOT_Misc, 0.5,,, 0.5+FRand());
				Spawn(class'SpriteSmokePuff',,,HitLocation);
				Spawn(class'GoFragment',,,HitLocation);
			}
			else
			{
				bld=Spawn(class'BloodBurst');
				bld.SetLocation(HitLocation);
				PlaySound(ImpactSound, SLOT_Misc, 0.5,,, 0.5+FRand());
				Spawn(class'SpriteSmokePuff',,,HitLocation);
				Spawn(class'GoFragment',,,HitLocation);
			}
			Destroy();
		}
	}

	simulated function HitWall( vector HitNormal, actor Wall )
	{
		local actor bld;
		
		Super.HitWall(HitNormal, Wall);	
		PlaySound(ImpactSound, SLOT_Misc, 0.5,,, 0.5+FRand());
		bld=Spawn(class'BloodBurst');
		bld.SetLocation(HitNormal);
		Destroy();
	}

	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local GoFragment G;

		if (Level.NetMode != NM_DedicatedServer)
		{
			Spawn(class'SpriteSmokePuff',,,HitLocation + HitNormal*16);
      	G = Spawn(class'GoFragment',,,HitLocation + HitNormal*16);
      	G.RemoteRole = ROLE_None;
    		Destroy();
    	}
	}

	simulated function Timer()
	{
		local bubble1 b;

		if (Level.NetMode!=NM_DedicatedServer)
		{
	 		b=spawn(class'Bubble1'); 
 			b.DrawScale= 0.1 + FRand()*0.2;
 			b.SetLocation(Location+FRand()*vect(2,0,0)+FRand()*Vect(0,2,0)+FRand()*Vect(0,0,2));
 			b.buoyancy = b.mass+(FRand()*0.4+0.1);
 		}
		DelayTime+=FRand()*0.1+0.1;
		SetTimer(DelayTime,False);
		Destroy();
	}

	simulated function ZoneChange( Zoneinfo NewZone )
	{
		if (NewZone.bWaterZone) 
		{
			Velocity=0.7*Velocity;	
			DelayTime=0.03;		
			SetTimer(DelayTime,False);
		}
	}

	function BeginState()
	{
		local rotator RandRot;

		LoopAnim('Swim1',0.9,0.9);
		Velocity = Vector(Rotation) * speed;
		RandRot.Pitch = FRand() * 200 - 100;
		RandRot.Yaw = FRand() * 200 - 100;
		RandRot.Roll = FRand() * 200 - 100;
		Velocity = Velocity >> RandRot;
		if( Region.zone.bWaterZone )
			Velocity=0.7*Velocity;
	}
}

simulated function AnimEnd()
{
}

defaultproperties
{
	FishSkins(0)=Texture'UnrealShare.Skins.Jfish21'
   FishSkins(1)=Texture'UnrealShare.Skins.Jfish22'
   FishSkins(2)=Texture'UnrealShare.Skins.Jfish23'
   FishSkins(3)=Texture'UnrealShare.Skins.Jfish24'
   FishSkins(4)=Texture'UnrealShare.Skins.Jfish25'
   FishSkins(5)=Texture'UnrealShare.Skins.Jfish26'
   ImpactSound=Sound'UnrealShare.Gibs.Gib1'
   ExplosionDecal=Class'Botpack.BloodSplat'
   Texture=Texture'Engine.S_Pawn'
   Skin=Texture'UnrealShare.Skins.Jfish21'
   Mesh=LodMesh'UnrealShare.AmbientFish'
   LightBrightness=131
   LightHue=51
   LightSaturation=20
}
